//
//  ViewController.swift
//  userDefaults_Bool
//
//  Created by yoshiyuki oshige on 2015/09/21.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // スイッチをOutlet接続する
    @IBOutlet weak var mySwitch1: UISwitch!
    @IBOutlet weak var mySwitch2: UISwitch!
    
    // ユーザーデフォルトに保存する
    @IBAction func saveStatus(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // mySwitch1の値をキー"switchOn"で保存する
        defaults.setBool(mySwitch1.on, forKey: "switchOn")
    }
    
    // ユーザーデフォルトから読み込む
    @IBAction func readStatus(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"switchOn"の値をBoolとして読んでmySwitch2に設定する
        mySwitch2.on = defaults.boolForKey("switchOn")
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}