//
//  ViewController.swift
//  userDefaults_Float
//
//  Created by yoshiyuki oshige on 2015/09/21.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // スライダとラベルをOutlet接続する
    @IBOutlet weak var mySlider: UISlider!
    @IBOutlet weak var sliderLabel: UILabel!
    // プログレスバーとラベルをOutlet接続する
    @IBOutlet weak var myProgress: UIProgressView!
    @IBOutlet weak var progressLabel: UILabel!
    
    // ユーザーデフォルトに保存する
    @IBAction func saveValue(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        let value = mySlider.value
        // ラベルに値を表示する
        sliderLabel.text = String(value)
        // キー"sliderValue"で値を保存する
        defaults.setFloat(value, forKey: "sliderValue")
    }
    
    // ユーザーデフォルトから読み込む
    @IBAction func readValue(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"sliderValue"をFloatとして値を読み込む
        let value = defaults.floatForKey("sliderValue")
        // ラベルに値を表示する
        progressLabel.text = String(value)
        // プログレスバーに値を設定する
        myProgress.progress = value
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}