//
//  ViewController.swift
//  userDefaults_String
//
//  Created by yoshiyuki oshige on 2015/09/20.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // テキストフィールド
    @IBOutlet weak var textField1: UITextField!
    @IBOutlet weak var textField2: UITextField!
    // ラベル
    @IBOutlet weak var myLabel: UILabel!
    
    // テキストフィールドのストリングを保存する
    @IBAction func saveText1(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"myText1"でtextField1のテキストを保存する
        defaults.setValue(textField1.text, forKey: "myText1")
        // キーボードを下げる
        view.endEditing(true)
    }
    
    // ユーザーデフォルトに保存する
    @IBAction func saveText2(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"myText2"でtextField2のテキストを保存する
        defaults.setValue(textField2.text, forKey: "myText2")
        // キーボードを下げる
        view.endEditing(true)
    }
    
    // ユーザーデフォルトから読み込む
    @IBAction func readText1(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"myText1"をStringとして読み込む
        if let myText = defaults.stringForKey("myText1") {
            myLabel.text = myText
        }
    }
    
    // ユーザーデフォルトから読み込む
    @IBAction func readText2(sender: AnyObject) {
        // ユーザーデフォルトを参照する
        let defaults = NSUserDefaults.standardUserDefaults()
        // キー"myText2"をStringとして読み込む
        if let myText = defaults.stringForKey("myText2") {
            myLabel.text = myText
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

