//
//  ViewController.swift
//  nortificationCenter_keyboard
//
//  Created by yoshiyuki oshige on 2015/09/22.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    // テキストファイルのパス
    let thePath = NSHomeDirectory()+"/Documents/myTextfile.txt"
    // ビューとテキストビューの下辺との間隔
    var gapBottom:CGFloat!
    
    @IBOutlet weak var myTextView: UITextView!
    
    // 編集をキャンセルする
    @IBAction func cancel(sender: AnyObject) {
        // キーボードを下げる
        view.endEditing(true)
        // ファイルから読み込む
        readFromFile()
    }
    
    // ファイルへの保存
    @IBAction func saveToFile(sender: AnyObject) {
        // キーボードを下げる
        view.endEditing(true)
        // 保存するテキストデータ
        let textData = myTextView.text
        // テキストデータの保存をトライする
        do {
            try textData.writeToFile(thePath, atomically: true, encoding: NSUTF8StringEncoding)
        } catch let error as NSError {
            print("保存に失敗。\n \(error)")
        }
    }
    
    // ファイルからの読み込み
    func readFromFile() {
        // ファイルマネージャを作る
        let fileManager = NSFileManager.defaultManager()
        // ファイルが存在するかどうかチェックする
        if fileManager.fileExistsAtPath(thePath) {
            // テキストデータの読み込みをトライする
            do {
                let textData = try String(contentsOfFile: thePath, encoding: NSUTF8StringEncoding)
                // 読み込みが成功したならば表示する
                myTextView.text = textData
            } catch let error as NSError {
                myTextView.text = "読み込みに失敗。\n \(error)"
            }
        } else {
            print("ファイルが存在しない。")
        }
    }
    
    override func viewDidAppear(animated: Bool) {
        // ビューとテキストビューの下辺との間隔
        gapBottom = view.frame.height - myTextView.frame.maxY
    }
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ファイルから読み込む
        readFromFile()
        
        // 通知センターのオブジェクトを作る
        let notification = NSNotificationCenter.defaultCenter()
        
        // キーボードが表示された
        notification.addObserver(self,
            selector: Selector("keyboardDidShow:"),
            name: UIKeyboardDidShowNotification, object: nil)
        // キーボードのframeが変更された
        notification.addObserver(self,
            selector: Selector("keyboardChangeFrame:"),
            name: UIKeyboardDidChangeFrameNotification, object: nil)
        // キーボードが隠れた
        notification.addObserver(self,
            selector: Selector("keyboardDidHide:"),
            name: UIKeyboardDidHideNotification, object: nil)
    }

    // キーボードが表示されたとき実行
    func keyboardDidShow(notification: NSNotification) {
       let keybordFrame = notification.userInfo?[UIKeyboardFrameEndUserInfoKey]
        // キーボードのframeを調べる
        if let kbFrame = keybordFrame?.CGRectValue {
            // キーボードで隠れないようにテキストビューの高さを変更する
           var textViewFrame = myTextView.frame
            textViewFrame.size.height = kbFrame.minY - textViewFrame.minY - 5
            myTextView.frame = textViewFrame
        }
    }
    
    // キーボードのframeが変更されたとき実行
    func keyboardChangeFrame(notification: NSNotification) {
        let keybordFrame = notification.userInfo?[UIKeyboardFrameEndUserInfoKey]
        // キーボードのframeを調べる
        if let kbFrame = keybordFrame?.CGRectValue {
            // キーボードで隠れないようにテキストビューの高さを変更する
            var textViewFrame = myTextView.frame
            textViewFrame.size.height = kbFrame.minY - textViewFrame.minY - 5
            myTextView.frame = textViewFrame
        }
    }
    
    // キーボードが隠れたとき実行
    func keyboardDidHide(notification: NSNotification) {
        var textViewFrame = myTextView.frame
        // キーボードが隠れたときの高さ（画面の回転に対応するために再計算する）
        let textViewHeight = view.frame.maxY - textViewFrame.minY - gapBottom
        textViewFrame.size.height = textViewHeight
        // テキストビューのサイズを戻す
        myTextView.frame = textViewFrame
    }
  
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

