//
//  ViewController.swift
//  nortificationCenter_orientation
//
//  Created by yoshiyuki oshige on 2015/09/24.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var labelABC: UILabel!
    @IBOutlet weak var labelA: UILabel!
    @IBOutlet weak var labelB: UILabel!
    @IBOutlet weak var labelC: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // 通知センターのオブジェクトを作る
        let notification = NSNotificationCenter.defaultCenter()
        // デバイスの向きが変わった
        notification.addObserver(self,
            selector: Selector("changedDeviceOrientation:"),
            name: UIDeviceOrientationDidChangeNotification, object: nil)
    }
 
    // イベントで呼び出されるメソッド
    func changedDeviceOrientation(notification :NSNotification) {
        // デバイスを取得する
        let device = UIDevice.currentDevice()
        // デバイスの向きを調べる
        switch device.orientation {
        case .Portrait: // ポートレート
            // ラベルを0度に回転
            rotateLabel(0)
        case .PortraitUpsideDown: // 逆さま
            // ラベルを180度に回転
            rotateLabel(CGFloat(M_PI))
        case .LandscapeLeft: // デバイスは左回転
            // ラベルは90度に回転
             rotateLabel(CGFloat(M_PI_2))
        case .LandscapeRight: // デバイスは右回転
            // ラベルは-90度に回転
            rotateLabel(CGFloat(-M_PI_2))
        default:
            break
        }
    }

    // ラベルを回転させる
    func rotateLabel(radian :CGFloat) {
        labelABC.transform = CGAffineTransformMakeRotation(radian)
        labelA.transform = CGAffineTransformMakeRotation(radian)
        labelB.transform = CGAffineTransformMakeRotation(radian)
        labelC.transform = CGAffineTransformMakeRotation(radian)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}


