//
//  ViewController.swift
//  avCapture_stillimage
//
//  Created by yoshiyuki oshige on 2015/09/25.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController {
    
    // 画像のアウトプット
    var myImageOutput:AVCaptureStillImageOutput!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // セッションの作成
        let mySession = AVCaptureSession()
        //解像度の指定
        mySession.sessionPreset = AVCaptureSessionPresetHigh
        
        // 撮影に使うカメラ
        var myCamera:AVCaptureDevice!
        //デバイス一覧の取得
        let devices = AVCaptureDevice.devices()
        for device in devices{
            // バックカメラで撮影する
            if(device.position == AVCaptureDevicePosition.Back){
                myCamera = device as! AVCaptureDevice
            }
        }
        
        // カメラからVideoInputを取得する
        do {
            // 入力元
            let videoInput = try AVCaptureDeviceInput(device: myCamera)
            mySession.addInput(videoInput)
            
            // 出力先
            myImageOutput = AVCaptureStillImageOutput()
            mySession.addOutput(myImageOutput)
            
            // 画像を表示するプレビューレイヤを作る
            let myVideoLayer = AVCaptureVideoPreviewLayer(session: mySession)
            myVideoLayer.frame = view.bounds
            myVideoLayer.videoGravity = AVLayerVideoGravityResizeAspectFill
            // 最背面になるようにプレビューレイヤを挿入する
            view.layer.insertSublayer(myVideoLayer, atIndex: 0)
            
            // セッション開始
            mySession.startRunning()

        } catch let error as NSError {
            print("カメラは使えません。\(error)")
        }
    }
    
    // シャッターボタンで実行する
    @IBAction func takePhoto(sender: AnyObject) {
        // ビデオ出力に接続する
        let myAVConnection = myImageOutput.connectionWithMediaType(AVMediaTypeVideo)
        
        // 接続から画像を取得する
        myImageOutput.captureStillImageAsynchronouslyFromConnection(myAVConnection, completionHandler: { (imageDataBuffer, error) -> Void in
            // ビデオ画像をキャプチャする
            let myImageData = AVCaptureStillImageOutput.jpegStillImageNSDataRepresentation(imageDataBuffer)
            let stillImage = UIImage(data: myImageData)
        
            // カメラロールに追加する
            UIImageWriteToSavedPhotosAlbum(stillImage!, self, nil, nil)
        })
    }

}