//
//  ViewController.swift
//  avCapture_stamp
//
//  Created by yoshiyuki oshige on 2015/09/25.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController {
    
    // スタンプにするイメージビュー
    var stampView:UIImageView!
    let stampImage = UIImage(named: "flower")!
    
    // 画像のアウトプット
    var myImageOutput:AVCaptureStillImageOutput!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // セッションの作成
        let mySession = AVCaptureSession()
        //解像度の指定
        mySession.sessionPreset = AVCaptureSessionPresetHigh
        // 撮影に使うカメラ
        let myCamera = AVCaptureDevice.defaultDeviceWithMediaType(AVMediaTypeVideo)
        
        // カメラからVideoInputを取得
        do {
            // 入力元
            let videoInput = try AVCaptureDeviceInput(device: myCamera) as AVCaptureDeviceInput
            mySession.addInput(videoInput)
            
            // 出力先
            myImageOutput = AVCaptureStillImageOutput()
            mySession.addOutput(myImageOutput)
            
            // 画像を表示するプレビューレイヤを作る
            let myVideoLayer = AVCaptureVideoPreviewLayer(session: mySession)
            myVideoLayer.frame = view.bounds
            myVideoLayer.videoGravity = AVLayerVideoGravityResizeAspectFill
            // 最背面になるようにプレビューレイヤを挿入する
            view.layer.insertSublayer(myVideoLayer, atIndex: 0)
            
            // スタンプを表示する
            stampView = UIImageView(image: stampImage)
            stampView.center = CGPointMake(100, 100)
            view.addSubview(stampView)
            
            // セッション開始
            mySession.startRunning()
            
        } catch let error as NSError {
            print("カメラは使えません。\(error)")
        }
    }
    
    // シャッターボタンで実行する
    @IBAction func takePhoto(sender: AnyObject) {
        // ビデオ出力に接続する
        let myAVConnection = myImageOutput.connectionWithMediaType(AVMediaTypeVideo)
        
        // 接続から画像を取得する
        myImageOutput.captureStillImageAsynchronouslyFromConnection(myAVConnection,
            completionHandler: { (imageDataBuffer, error) -> Void in
                
                // ビデオ画像をキャプチャする
                let myImageData = AVCaptureStillImageOutput.jpegStillImageNSDataRepresentation(imageDataBuffer)
                let stillImage = UIImage(data: myImageData)
                let composedImage = self.composeImage(stillImage!)
                
                // カメラロールに追加する
                UIImageWriteToSavedPhotosAlbum(composedImage, self, nil, nil)
                
        })
    }
    
    // スタンプと合成する
    func composeImage(stillImage: UIImage) -> UIImage {
        // 画像のサイズ
        let imageWidth = (stillImage.size.width)
        let imageHeight = (stillImage.size.height)
        // ビューのサイズ
        let viewWidth = self.view.bounds.width
        // 画像とビューの比率
        let scale = imageWidth / viewWidth
        
        // 合成開始
        UIGraphicsBeginImageContext(CGSizeMake(imageWidth, imageHeight))
        stillImage.drawInRect(CGRectMake(0, 0, imageWidth, imageHeight))
        // スタンプと画像の合成
        let stampW = stampImage.size.width * scale
        let stampH = stampImage.size.height * scale
        let stampX = self.stampView.center.x * scale - stampW/2
        let stampY = self.stampView.center.y * scale - stampH/2
        stampImage.drawInRect(CGRectMake(stampX, stampY, stampW, stampH))
        // 合成後のイメージ
        let composedImage = UIGraphicsGetImageFromCurrentImageContext()
        
        // イメージを回転させる向き
        var imageOrientation:UIImageOrientation!
        // デバイスを取得する
        let device = UIDevice.currentDevice()
        // デバイスの向きを調べる
        switch device.orientation {
        case .Portrait: // ポートレート
            imageOrientation = UIImageOrientation.Up
        case .PortraitUpsideDown: // 逆さま
            imageOrientation = UIImageOrientation.Down
        case .LandscapeLeft: // 左回転
            imageOrientation = UIImageOrientation.Left
        case .LandscapeRight: // 右回転
            imageOrientation = UIImageOrientation.Right
        default:
            break
        }
        // デバイスの向きに合わせて回転させたイメージ
        let rotatedImage = UIImage(CGImage: composedImage.CGImage!, scale: 1.0, orientation: imageOrientation)
        
        // 合成終了
        UIGraphicsEndImageContext()
        return rotatedImage
    }
    
    // タッチしたところにスタンプを移動させる
    @IBAction func tapView(sender: UITapGestureRecognizer) {
        stampView.center = sender.locationInView(view)
    }
    
    // スタンプをドラッグする
    @IBAction func dragStamp(sender: UIPanGestureRecognizer) {
        stampView.center = sender.locationInView(view)
    }
    
    
}