//
//  ViewController.swift
//  avCapture_stillimage_share
//
//  Created by yoshiyuki oshige on 2015/09/27.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController {
    
    // 画像のアウトプット
    var myImageOutput:AVCaptureStillImageOutput!
    // 撮影した写真イメージ
    var stillImage:UIImage?
    
    // ツールバーのシェアボタン
    @IBOutlet weak var shareButton: UIBarButtonItem!
    
    // シェアボタンで実行する
    @IBAction func share(sender: AnyObject) {
        // シェアする内容を作る
        let sharedText = "シェアします。"
        let activities:[AnyObject] = [sharedText, stillImage!]
        let appActivities = [UIActivity()]
        // アクティビティコントローラを表示する
        let activityVC = UIActivityViewController(activityItems: activities, applicationActivities: appActivities)
        self.presentViewController(activityVC, animated: true, completion: nil)
    }
    
    // シャッターボタンで実行する
    @IBAction func takePhoto(sender: AnyObject) {
        // ビデオ出力に接続する
        let myAVConnection = myImageOutput.connectionWithMediaType(AVMediaTypeVideo)
        
        // 接続から画像を取得する
        myImageOutput.captureStillImageAsynchronouslyFromConnection(myAVConnection, completionHandler: { (imageDataBuffer, error) -> Void in
            // ビデオ画像をキャプチャする
            let myImageData = AVCaptureStillImageOutput.jpegStillImageNSDataRepresentation(imageDataBuffer)
            self.stillImage = UIImage(data: myImageData)
            
            // カメラロールに追加する
            UIImageWriteToSavedPhotosAlbum(self.stillImage!, self, nil, nil)
            // ツールバーのシェアボタンを有効にする
            self.shareButton.enabled = true
        })
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ツールバーのシェアボタンを無効にする
        shareButton.enabled = false
        
        // セッションの作成
        let mySession = AVCaptureSession()
        //解像度の指定
        mySession.sessionPreset = AVCaptureSessionPresetHigh
        
        // 撮影に使うカメラ
        var myCamera:AVCaptureDevice!
        //デバイス一覧の取得
        let devices = AVCaptureDevice.devices()
        for device in devices{
            // バックカメラで撮影する
            if(device.position == AVCaptureDevicePosition.Back){
                myCamera = device as! AVCaptureDevice
            }
        }
        
        // カメラからVideoInputを取得する
        do {
            // 入力元
            let videoInput = try AVCaptureDeviceInput(device: myCamera)
            mySession.addInput(videoInput)
            
            // 出力先
            myImageOutput = AVCaptureStillImageOutput()
            mySession.addOutput(myImageOutput)
            
            // 画像を表示するプレビューレイヤを作る
            let myVideoLayer = AVCaptureVideoPreviewLayer(session: mySession)
            myVideoLayer.frame = view.bounds
            myVideoLayer.videoGravity = AVLayerVideoGravityResizeAspectFill
            // 最背面になるようにプレビューレイヤを挿入する
            view.layer.insertSublayer(myVideoLayer, atIndex: 0)
            
            // セッション開始
            mySession.startRunning()
            
        } catch let error as NSError {
            print("カメラは使えません。\(error)")
        }
    }
    
}
