//
//  ViewController.swift
//  map_tracking
//
//  Created by yoshiyuki oshige on 2015/09/29.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit
import CoreLocation
import MapKit

class ViewController: UIViewController, CLLocationManagerDelegate, MKMapViewDelegate {
    // 地図
    @IBOutlet weak var myMap: MKMapView!
    // トラッキングボタン
    @IBOutlet weak var trackingButton: UIBarButtonItem!
    
    // ロケーションマネージャを作る
    var locationManager = CLLocationManager()

    override func viewDidLoad() {
        super.viewDidLoad()
        // アプリ利用中の位置情報の利用許可を得る
        locationManager.requestWhenInUseAuthorization()
        // ロケーションマネージャのデリゲートになる
        locationManager.delegate = self
        // myMapのデリゲートになる
        myMap.delegate = self
        // スケールを表示する
        myMap.showsScale = true
    }
    
    // トラッキングモードを切り替える
    @IBAction func tapTrackingButton(sender: UIBarButtonItem) {
        switch myMap.userTrackingMode {
        case .None:
            // NoneからFollowへ
            myMap.setUserTrackingMode(.Follow, animated: true)
            // トラッキングボタンを変更する
            trackingButton.image = UIImage(named: "trackingFollow")
        case .Follow:
            // FollowからFollowWithHeadingへ
            myMap.setUserTrackingMode(.FollowWithHeading, animated: true)
            // トラッキングボタンを変更する
            trackingButton.image = UIImage(named: "trackingHeading")
        case .FollowWithHeading:
            // FollowWithHeadingからNoneへ
            myMap.setUserTrackingMode(.None, animated: true)
            // トラッキングボタンを変更する
            trackingButton.image = UIImage(named: "trackingNone")
        }
    }
    
    // トラッキングが自動解除された
    func mapView(mapView: MKMapView, didChangeUserTrackingMode mode: MKUserTrackingMode, animated: Bool) {
        // トラッキングボタンを変更する
        trackingButton.image = UIImage(named: "trackingNone")
    }
    
    
    // 位置情報利用許可のステータスが変わった
    func locationManager(manager: CLLocationManager, didChangeAuthorizationStatus status: CLAuthorizationStatus) {
        switch status {
        case .AuthorizedAlways, .AuthorizedWhenInUse :
            // ロケーションの更新を開始する
            locationManager.startUpdatingLocation()
            // トラッキングボタンを有効にする
            trackingButton.enabled = true
        default:
            // ロケーションの更新を停止する
            locationManager.stopUpdatingLocation()
            // トラッキングモードを.Noneにする
            myMap.setUserTrackingMode(.None, animated: true)
            //トラッキングボタンを変更する
            trackingButton.image = UIImage(named: "trackingNone")
            // トラッキングボタンを無効にする
            trackingButton.enabled = false
        }
    }
    

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

